require( "quest/m2_sizzle1/convout.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:SetWalkSpeed(flo_speed);
		
		if game:GetLastScene() == "m2_intersection" then
			actor:FaceNow(DIR.W);
			actor:JumpToNamedPoint("flo_intersection");
			scene:SetCameraFollowActor(actor);
			scene.CAMERA:JumpToNamedPoint("flo_east");
			actor:WalkTo("flo_east");
			wait_walkto();
			actor:Face(DIR.S);
			spawn_nav_arrow(to_bakery_spec);
			game:SetString("map_position", "m2_bakery");
		elseif game:GetLastScene() == "subway" then
			actor:FaceNow(DIR.S);
			actor:JumpToNamedPoint("subway");
			scene.CAMERA:JumpToNamedPoint("flo_west");
			actor:WalkTo("flo_west");
			wait_walkto();
			actor:Face(DIR.S);
		else
			actor:FaceNow(DIR.S);
			actor:JumpToNamedPoint("bakery");
			scene.CAMERA:JumpToNamedPoint("flo_east");
			actor:WalkTo("flo_east");
			delay(3);
			scene.DOOR:PlayAnim("Close");
			wait_walkto();
			
			if game:Get("cake_just_delivered") == 1 then
				game:Set("cake_just_delivered", 2);
				if flo_after_napkin_prompt(actor) == false then
					run_super_conversation(actor, "quip_flo_general_P");
				end
			end
			
			actor:Face(DIR.S);
			spawn_nav_arrow(to_bakery_spec);
		end
		
		scene:SetCameraFollowActor(scene.CAMERA);
		actor:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
	
	on_arrive = function(flo1, flo2)
		convproc("FLO", "quip_flo_general");
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function gotointersection(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene.TO_BAKERY:Expire();
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("to_intersection");
	delay(150);
	goto_scene(flo, "m2_intersection", true);
end

to_intersection_spec = 
{
	name = "TO_INTERSECTION";
	halo = "to_intersection";
	cursor = "cursor_arrow_e";
	goto_fn = gotointersection;
}

function gotosizzlewest(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene.TO_BAKERY:Expire();
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("flo_west");
	wait_walkto();
	flo:Face(DIR.S);
	
	game:SetString("map_position", "m2_subway");
	
	flo:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene.CAMERA:JumpToNamedPoint("flo_west");
	scene:SetCameraFollowActor(scene.CAMERA);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

to_sizzlewest_spec = 
{
	name = "TO_SIZZLEWEST";
	halo = "to_sizzlewest";
	cursor = "cursor_arrow_w";
	goto_fn = gotosizzlewest;
}

function gotosizzleeast(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("flo_east");
	wait_walkto();
	flo:Face(DIR.S);
	
	game:SetString("map_position", "m2_bakery");
	
	flo:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene.CAMERA:JumpToNamedPoint("flo_east");
	scene:SetCameraFollowActor(scene.CAMERA);
	spawn_nav_arrow(to_bakery_spec);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

to_sizzleeast_spec = 
{
	name = "TO_SIZZLEEAST";
	halo = "to_sizzleeast";
	cursor = "cursor_arrow_e";
	goto_fn = gotosizzleeast;
}

function gotosubway(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("subway");
	wait_walkto();

	goto_scene(flo, "subway");
end;

to_subway_spec = 
{
	name = "TO_SUBWAY";
	halo = "to_subway";
	cursor = "cursor_arrow_s";
	goto_fn = gotosubway;
}

function gotobakery(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("module_progress") < 3 then
		flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		flo:WalkTo("bakery");
		wait_walkto();
		
		goto_scene(flo, "m2_bakery");
	else
		run_super_conversation(flo, "quip_shop_closed");
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end;

to_bakery_spec = 
{
	name = "TO_BAKERY";
	halo = "to_bakery";
	cursor = "cursor_arrow_n";
	goto_fn = gotobakery;
	point_at_fn = function(actor, enter)
		if actor:GetMode() ~= MODE.CUTSCENE and game:Get("module_progress") < 3 then
			if enter then
				scene.DOOR:PlayAnim("Open");
			else
				scene.DOOR:PlayAnim("Close");
			end
		end
	end;
}

door_spec =
{
	name = "DOOR";
	gfx = {anim = "anim/m2_sizzle1/door"};
	
	command = function(actor)
		actor:PlayAnim("Closed");
		actor:SetDepthValue("1");
	end;
}

function use_recycle_machine(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("recyclemachine");
	wait_walkto();
	
	flo:FaceActor(actor);
	delay(30);
	
	scene:ChainToSubScene("recyclemachine");
	wait_subscene();
	
	flo:WalkTo("flo_west");
	wait_walkto();
	flo:Face(DIR.S);
	
	flo:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

recyclemachine_spec = 
{
	name = "RECYCLE_MACHINE";
	halo = "recyclemachine";
	
	command = function(actor)
		actor:SetDepthValue(200);
	end;
	
	on_arrive = function(flo, actor)
		flo:FaceActor(actor);
		flo:StartProc(use_recycle_machine);
	end;
	
	on_use_inv = function(item, flo, actor)
		if item == "recyclable" then
			flo:StartProc(use_recycle_machine);
			return RESPONSE.INV_HANDLED;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
}

camera_spec = 
{
	name = "CAMERA";
	command = function(actor)

		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetWalkSpeed(6);
		
		if game:GetLastScene() == "m2_intersection" then
			actor:JumpToNamedPoint("flo_intersection");
		--[[elseif game:GetLastScene() == "m1_subwayred" then
			actor:JumpToNamedPoint("flo_east");
		else -- pet shop
			actor:JumpToNamedPoint("flo_west");]]--
		end
	end;
};

musician_anim_table = 
{
	"anim/musician/stand",
};

musician_spec = 
{
	name = "MUSICIAN";
	halo = "quest/objects/musician";
	anim = musician_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, musician_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("musician");
		actor:SetWalkSpeed(musician_speed);
		actor:FaceNow(DIR.W);
	end;
	
	on_arrive = function(flo, musician)
		flo:StartProc(talk_to_musician);
	end;
};

function talk_to_musician(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:Face(DIR.SE);
	sfx:KillSFX();
	sfx:PlaySFX("audio/sfx/ambient_mod1.ogg", true);
	local numtalks = game:Get( "talk_musician" );
	if ( numtalks == 0 ) then
		run_super_conversation(flo, "conv_musician_A");
	elseif ( fmod( numtalks, 2 ) == 1 ) then
		run_super_conversation(flo, "conv_musician_B");
	else
		run_super_conversation(flo, "conv_musician_C");
	end
	game:Set( "talk_musician", numtalks + 1 );
	flo:Face(DIR.S);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

sizzle_st_sign_spec = 
{
	name = "SIZZLE_ST_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/helvetica_nevelt_std_blk.mvec",
			color = { a = 1, r = 1, g = 1, b = 1 },
			outline_size = 0,
			lineheight = 20,
			linepadding = -7,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_sizzle_st_sign");
		actor:StopWalking();
		actor:SetPolygon({x=61,y=171}, {x=191,y=170}, {x=62,y=192}, {x=190,y=192});
		actor:TextToImage(10, 0);
	end;
}

subway_sign_spec = 
{
	name = "SUBWAY_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(100);
		actor:ModifySaySpec
		{
			font = "fonts/hobo_std.mvec",
			color = { a = 1, r = 0.11, g = 0.27, b = 0.25 },
			outline_size = 0,
			lineheight = 40,
			linepadding = 2,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_subway_sign");
		actor:StopWalking();
		actor:SetPolygon({x=226,y=207}, {x=356,y=207}, {x=226,y=244}, {x=356,y=244});
		actor:TextToImage(40, 0);
	end;
}

yum1_sign_spec = 
{
	name = "YUM1_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/hobo_std.mvec",
			color = { a = 1, r = 1, g = 1, b = 0.8 },
			outline_size = 0,
			lineheight = 26,
			linepadding = 2,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_yum_sign");
		actor:StopWalking();
		actor:SetPolygon({x=1667,y=81}, {x=1766,y=55}, {x=1705,y=120}, {x=1778,y=100});
		actor:TextToImage(10, 0);
	end;
}

yum2_sign_spec = 
{
	name = "YUM2_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/hobo_std.mvec",
			color = { a = 1, r = 1, g = 1, b = 0.8 },
			outline_size = 0,
			lineheight = 26,
			linepadding = 2,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_yum_sign");
		actor:StopWalking();
		actor:SetPolygon({x=1764,y=52}, {x=1863,y=80}, {x=1752,y=92}, {x=1852,y=121});
		actor:TextToImage(10, 0);
	end;
}

bakery_sign_spec = 
{
	name = "BAKERY_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/hobo_std.mvec",
			color = { a = 1, r = 0.26, g = 0, b = 0 },
			outline_size = 0,
			lineheight = 26,
			linepadding = 2,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_bakery_sign");
		actor:StopWalking();
		actor:SetPolygon({x=1686,y=115}, {x=1844,y=117}, {x=1686,y=153}, {x=1843,y=153});
		actor:TextToImage(20, 5);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		if IsCheatMode() then
			-- testing data
		end
		
		spawn_nav_arrow(to_intersection_spec);
		spawn_nav_arrow(to_sizzlewest_spec);
		spawn_nav_arrow(to_sizzleeast_spec);
		spawn_nav_arrow(to_subway_spec);
	
		sfx:SetMusic("audio/music/music_streets2.ogg", true);
		sfx:PlaySFX("audio/sfx/ambient_mod1.ogg", true);
		scene:SetRoomScale(300, 550, 0.6, 0.8);	--topline, bottomline, topscale, bottomscale
		
		local no_fade = game:GetLastScene() == "m2_intersection";
		fade_scene_up(false, no_fade);
		
		scene:SetCameraFollowActor(scene.CAMERA);		-- Attach the camera to follow "CAMERA" actor
		scene:SetCameraMargin { x = 400, y = 300 };
		
		if game:Get("module_progress") < 3 then
			scene:Spawn(musician_spec);
		end
		
		spawn_simple_hotspot("end_of_street", 5);
		spawn_simple_hotspot("sizzle1_bikes", 5);
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces", -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "mask_bike", 380 },
		{ "mask_bakery", 380 },
		{ "sign", 420 },
		{ "recycle", 300 },
		{ "firehydrant", 736  },
		{ "car02", 747  },
		{ "car01", 750  },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		camera_spec,
		scene_setup,
		door_spec,
		flo_spec, -- the main actor
		
		recyclemachine_spec,
		sizzle_st_sign_spec,
		subway_sign_spec,
		yum1_sign_spec,
		yum2_sign_spec,
		bakery_sign_spec,
	};
};
